/**
* \file: main.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <stdio.h>

#include "automounterctl.h"
#include "automounter_types.h"


int main(int argc, char *argv[])
{
	error_code_t result;

	result=automounterctl_init(argc,argv);
	if (result==RESULT_OK)
		result=automounterctl_start();

	automounterctl_deinit();

	if (result!=RESULT_OK && result!=RESULT_HELP_PRINTED)
	{
		automounterctl_error_message(result);
		return 1;
	}

	return 0;
}
